/**
* @par Copyright (C): 2010-2019, Shenzhen Yahboom Tech
* @file         CarRun01.ino
* @author       chengengyue
* @version      V1.0
* @date         2019.10.08
* @brief        小车前后左右运动
* @details
* @par History  见如下说明
*/
// 导入库文件
#include <Adafruit_PWMServoDriver.h>
#include "Wire.h"

#define KEY_PIN 8    // 定义功能按键引脚

// 初始化PCA9685
Adafruit_PWMServoDriver pwm = Adafruit_PWMServoDriver(0x40);

// 小车控制参数
int CarSpeedControl = 60;

// 按键状态
bool button_press = false;

/**
* Function       run
* @author        chengengyue
* @date          2019.10.08
* @brief         小车前进
* @param[in]     Speed(0-160)
* @param[out]    void
* @retval        void
* @par History   无
*/
void run(int Speed)
{
  Speed = map(Speed, 0, 160, 0, 2560);
  pwm.setPWM(10, 0, Speed);    // 右前轮正转
  pwm.setPWM(11, 0, 0);
  pwm.setPWM(8, 0, Speed);     // 右后轮正转
  pwm.setPWM(9, 0, 0);

  pwm.setPWM(13, 0, Speed);    // 左前轮正转
  pwm.setPWM(12, 0, 0);
  pwm.setPWM(15, 0, Speed);    // 左后轮正转
  pwm.setPWM(14, 0, 0);
}

/**
* Function       brake
* @author        chengengyue
* @date          2019.10.08
* @brief         小车停住
* @param[in]     void
* @param[out]    void
* @retval        void
* @par History   无
*/
void brake()
{
  pwm.setPWM(8, 0, 0);
  pwm.setPWM(9, 0, 0);
  pwm.setPWM(11, 0, 0);
  pwm.setPWM(10, 0, 0);

  pwm.setPWM(12, 0, 0);
  pwm.setPWM(13, 0, 0);
  pwm.setPWM(14, 0, 0);
  pwm.setPWM(15, 0, 0);
}

/**
* Function       back
* @author        chengengyue
* @date          2019.10.08
* @brief         小车后退
* @param[in]     Speed(0-160)
* @param[out]    void
* @retval        void
* @par History   无
*/
void back(int Speed)
{
  Speed = map(Speed, 0, 160, 0, 2560);
  pwm.setPWM(10, 0, 0);
  pwm.setPWM(11, 0, Speed);    // 右前轮反转
  pwm.setPWM(8, 0, 0);
  pwm.setPWM(9, 0, Speed);     // 右后轮反转

  pwm.setPWM(13, 0, 0);
  pwm.setPWM(12, 0, Speed);    // 左前轮反转
  pwm.setPWM(15, 0, 0);
  pwm.setPWM(14, 0, Speed);    // 左后轮反转
}

/**
* Function       left
* @author        chengengyue
* @date          2019.10.08
* @brief         小车左平移(A轮反转，B轮正转)
* @param[in]     Speed(0-160)
* @param[out]    void
* @retval        void
* @par History   无
*/
void left(int Speed)
{
  Speed = map(Speed, 0, 160, 0, 2560);
  pwm.setPWM(10, 0, Speed);   // 右前轮正转
  pwm.setPWM(11, 0, 0);
  pwm.setPWM(8, 0, 0);
  pwm.setPWM(9, 0, Speed);    // 右后轮反转

  pwm.setPWM(13, 0, 0);
  pwm.setPWM(12, 0, Speed);   // 左前轮反转
  pwm.setPWM(15, 0, Speed);   // 左后轮正转
  pwm.setPWM(14, 0, 0);
}

/**
* Function       right
* @author        chengengyue
* @date          2019.10.08
* @brief         小车右平移(A轮正转，B轮反转)
* @param[in]     Speed(0-160)
* @param[out]    void
* @retval        void
* @par History   无
*/
void right(int Speed)
{
  Speed = map(Speed, 0, 160, 0, 2560);
  pwm.setPWM(10, 0, 0);
  pwm.setPWM(11, 0, Speed);   // 右前轮反转
  pwm.setPWM(8, 0, Speed);    // 右后轮正转
  pwm.setPWM(9, 0, 0);

  pwm.setPWM(13, 0, Speed);   // 左前轮正转
  pwm.setPWM(12, 0, 0);
  pwm.setPWM(15, 0, 0);
  pwm.setPWM(14, 0, Speed);   // 左后轮反转
}

/**
* Function       spin_left
* @author        chengengyue
* @date          2019.10.08
* @brief         小车原地左旋(左边轮反转，右边轮正转)
* @param[in]     Speed
* @param[out]    void
* @retval        void
* @par History   无
*/
void spin_left(int Speed)
{
  Speed = map(Speed, 0, 160, 0, 2560);
  pwm.setPWM(10, 0, Speed);   // 右前轮正转
  pwm.setPWM(11, 0, 0);
  pwm.setPWM(8, 0, Speed);    // 右后轮正转
  pwm.setPWM(9, 0, 0);

  pwm.setPWM(13, 0, 0);
  pwm.setPWM(12, 0, Speed);   // 左前轮反转
  pwm.setPWM(15, 0, 0);
  pwm.setPWM(14, 0, Speed);   // 左后轮反转
}

/**
* Function       spin_right
* @author        chengengyue
* @date          2019.06.25
* @brief         小车原地右旋(左边轮正转，右边轮反转)
* @param[in]     Speed
* @param[out]    void
* @retval        void
* @par History   无
*/
void spin_right(int Speed)
{
  Speed = map(Speed, 0, 160, 0, 2560);
  pwm.setPWM(10, 0, 0);
  pwm.setPWM(11, 0, Speed);   // 右前轮反转
  pwm.setPWM(8, 0, 0);
  pwm.setPWM(9, 0, Speed);    // 右后轮反转

  pwm.setPWM(13, 0, Speed);   // 左前轮正转
  pwm.setPWM(12, 0, 0);
  pwm.setPWM(15, 0, Speed);   // 左后轮正转
  pwm.setPWM(14, 0, 0);
}

void carRun01()
{
  right(CarSpeedControl);           // 小车向右平移
  delay(1000);                          
  back(CarSpeedControl);            // 小车向后运动1秒
  delay(1000);                          
  left(CarSpeedControl);            // 小车向左平移1秒
  delay(1000);                          
  run(CarSpeedControl);             // 小车向前运动1秒
  delay(1000);    
  brake();                          // 小车停止0.5秒
  delay(500);
  spin_left(CarSpeedControl);       // 小车左旋2秒
  delay(2000);
  brake();                          // 小车停止0.5秒
  delay(500);
  spin_right(CarSpeedControl);      // 小车右旋2秒
  delay(2000);
  brake();                          // 小车停止
}

/**
* Function       keyscan
* @author        chengengyue
* @date          2019.10.08
* @brief         按键扫描
* @param[in1]    void
* @retval        void
* @par History   无
*/
void keyscan()
{
  int val;
  val = digitalRead(KEY_PIN); // 读取数字8口电平值赋给val
  if (val == LOW)             // 当按键被按下时
  {
    delay(10);                  // 延时消抖
    val = digitalRead(KEY_PIN); // 再次读取按键状态
    while (val == LOW)
    {
      val = digitalRead(KEY_PIN); // 第三次读取按键状态
      if (val == HIGH)            // 判断按键是否松开，松开才执行
      {
        button_press = !button_press;
        return;
      }
    }
  }
}

/**
* Function       setup
* @author        chengengyue
* @date          2019.10.08
* @brief         初始化配置
* @param[in]     void
* @retval        void
* @par History   无
*/
void setup() {
  // put your setup code here, to run once:
  // 设置引脚模式
  pinMode(KEY_PIN, INPUT_PULLUP);
  
  // 使能I2C通讯
  Wire.begin();       
  
  // 初始化电机驱动IO为输出方式
  pwm.begin();
  pwm.setPWMFreq(60); // Analog servos run at ~60 Hz updates
  brake();            // 小车停止
}

/**
* Function       loop
* @author        chengengyue
* @date          2019.10.08
* @brief         主循环函数
* @param[in]     void
* @retval        void
* @par History   无
*/
void loop() {
  // put your main code here, to run repeatedly:
  // 扫描按键
  keyscan();

  if (button_press)     // 当按键被按下时让小车运行
  {
    delay(500);         // 延迟0.5秒后再运动
    carRun01();         // 开启运动
    button_press = 0;   // 按键状态复位
  }
}
